{% raw %}

/* gettext-compatible _ function, example of usage:
 *
 * > // Loading pl_PL.json here (containing polish translation strings generated by tools/i18n_compile.php)
 * > alert(_("Hello!"));
 * Witaj!
 */
function _(s) {
	return (typeof l10n != 'undefined' && typeof l10n[s] != 'undefined') ? l10n[s] : s;
}

/* printf-like formatting function, example of usage:
 *
 * > alert(fmt("There are {0} birds on {1} trees", [3,4]));
 * There are 3 birds on 4 trees
 * > // Loading pl_PL.json here (containing polish translation strings generated by tools/locale_compile.php)
 * > alert(fmt(_("{0} users"), [3]));
 * 3 uzytkownikow
 */
function fmt(s,a) {
	return s.replace(/\{([0-9]+)\}/g, function(x) { return a[x[1]]; });
}
function setUI(e){
	var expires = new Date();
	expires.setTime(expires.getTime() + (1000 * 24 * 60 * 60 * 1000));
	document.cookie = "ui" + '=' + "2" + ';expires=' + expires.toUTCString() + ';path=/';
	location.reload(); 
}

function until($timestamp) {
        var $difference = $timestamp - Date.now()/1000|0, $num;
        switch(true){
        case ($difference < 60):
                return "" + $difference + ' ' + _('second(s)');
        case ($difference < 3600): //60*60 = 3600
                return "" + ($num = Math.round($difference/(60))) + ' ' + _('minute(s)');
        case ($difference < 86400): //60*60*24 = 86400
                return "" + ($num = Math.round($difference/(3600))) + ' ' + _('hour(s)');
        case ($difference < 604800): //60*60*24*7 = 604800
                return "" + ($num = Math.round($difference/(86400))) + ' ' + _('day(s)');
        case ($difference < 31536000): //60*60*24*365 = 31536000
                return "" + ($num = Math.round($difference/(604800))) + ' ' + _('week(s)');
        default:
                return "" + ($num = Math.round($difference/(31536000))) + ' ' + _('year(s)');
        }
}


function ago($timestamp) {
        var $difference = (Date.now()/1000|0) - $timestamp, $num;
        switch(true){
        case ($difference < 60) :
                return "" + $difference + ' ' + _('second(s)');
        case ($difference < 3600): //60*60 = 3600
                return "" + ($num = Math.round($difference/(60))) + ' ' + _('minute(s)');
        case ($difference <  86400): //60*60*24 = 86400
                return "" + ($num = Math.round($difference/(3600))) + ' ' + _('hour(s)');
        case ($difference < 604800): //60*60*24*7 = 604800
                return "" + ($num = Math.round($difference/(86400))) + ' ' + _('day(s)');
        case ($difference < 31536000): //60*60*24*365 = 31536000
                return "" + ($num = Math.round($difference/(604800))) + ' ' + _('week(s)');
        default:
                return "" + ($num = Math.round($difference/(31536000))) + ' ' + _('year(s)');
        }
}

var datelocale =
        { days: [_('Sunday'), _('Monday'), _('Tuesday'), _('Wednesday'), _('Thursday'), _('Friday'), _('Saturday')]
        , shortDays: [_("Sun"), _("Mon"), _("Tue"), _("Wed"), _("Thu"), _("Fri"), _("Sat")]
        , months: [_('January'), _('February'), _('March'), _('April'), _('May'), _('June'), _('July'), _('August'), _('September'), _('October'), _('November'), _('December')]
        , shortMonths: [_('Jan'), _('Feb'), _('Mar'), _('Apr'), _('May'), _('Jun'), _('Jul'), _('Aug'), _('Sep'), _('Oct'), _('Nov'), _('Dec')]
        , AM: _('AM')
        , PM: _('PM')
        , am: _('am')
        , pm: _('pm')
        };


function alert(a, do_confirm, confirm_ok_action, confirm_cancel_action, no_ok) {
            var handler, div, bg, closebtn, okbtn;
      var close = function() {
              handler.fadeOut(400, function() { handler.remove(); });
              return false;
      };

      handler = $("<div id='alert_handler'></div>").hide().appendTo('body');

      bg = $("<div id='alert_background'></div>").appendTo(handler);

      div = $("<div id='alert_div'></div>").appendTo(handler);
      closebtn = $("<a id='alert_close' href='javascript:void(0)'><i class='fa fa-times'></i></div>")
              .appendTo(div);

      $("<div id='alert_message'></div>").html(a).appendTo(div);

	  if(!no_ok){
		okbtn = $("<button class='button alert_button'>"+_("OK")+"</button>").appendTo(div);
	  }
      if (do_confirm) {
              confirm_ok_action = (typeof confirm_ok_action !== "function") ? function(){} : confirm_ok_action;
              confirm_cancel_action = (typeof confirm_cancel_action !== "function") ? function(){} : confirm_cancel_action;
              okbtn.click(confirm_ok_action);
              $("<button class='button alert_button'>"+_("Cancel")+"</button>").click(confirm_cancel_action).click(close).appendTo(div);
              bg.click(confirm_cancel_action);
              okbtn.click(confirm_cancel_action);
              closebtn.click(confirm_cancel_action);
      }

      bg.click(close);
	  if(!no_ok){
		okbtn.click(close);
	  }
      closebtn.click(close);

      handler.fadeIn(400);
}

var saved = {};

var selectedstyle = '{% endraw %}{{ config.default_stylesheet.0|addslashes }}{% raw %}';
var styles = {
	{% endraw %}
	{% for stylesheet in stylesheets %}{% raw %}'{% endraw %}{{ stylesheet.name|addslashes }}{% raw %}' : '{% endraw %}{{ stylesheet.uri|addslashes }}{% raw %}',
	{% endraw %}{% endfor %}{% raw %}
};

if (typeof board_name === 'undefined') {
	var board_name = false;
}

function changeStyle(styleName, link) {
	{% endraw %}
	{% if config.stylesheets_board %}{% raw %}
		if (board_name) {
			stylesheet_choices[board_name] = styleName;
			localStorage.board_stylesheets = JSON.stringify(stylesheet_choices);
		}
	{% endraw %}{% else %}
		localStorage.stylesheet = styleName;
	{% endif %}
	{% raw %}

	if (!document.getElementById('stylesheet')) {
		var s = document.createElement('link');
		s.rel = 'stylesheet';
		s.type = 'text/css';
		s.id = 'stylesheet';
		var x = document.getElementsByTagName('head')[0];
		x.appendChild(s);
	}

	document.getElementById('stylesheet').href = styles[styleName];
	selectedstyle = styleName;

	if (document.getElementsByClassName('styles').length != 0) {
		var styleLinks = document.getElementsByClassName('styles')[0].childNodes;
		for (var i = 0; i < styleLinks.length; i++) {
			styleLinks[i].className = '';
		}
	}

	if (link) {
		link.className = 'selected';
	}

	if (typeof $ != 'undefined')
		$(window).trigger('stylesheet', styleName);
}


{% endraw %}
{% if config.stylesheets_board %}
	{% raw %}

	if (!localStorage.board_stylesheets) {
		localStorage.board_stylesheets = '{}';
	}

	var stylesheet_choices = JSON.parse(localStorage.board_stylesheets);
	if (board_name && stylesheet_choices[board_name]) {
		for (var styleName in styles) {
			if (styleName == stylesheet_choices[board_name]) {
				changeStyle(styleName);
				break;
			}
		}
	}
	{% endraw%}
{% else %}
	{% raw %}
	if (localStorage.stylesheet) {
		for (var styleName in styles) {
			if (styleName == localStorage.stylesheet) {
				changeStyle(styleName);
				break;
			}
		}
	}
	{% endraw %}
{% endif %}
{% raw %}

function init_stylechooser() {
	var newElement = document.createElement('div');
	newElement.className = 'styles';

	for (styleName in styles) {
		var style = document.createElement('a');
		style.innerHTML = '[' + styleName + ']';
		style.onclick = function() {
			changeStyle(this.innerHTML.substring(1, this.innerHTML.length - 1), this);
		};
		if (styleName == selectedstyle) {
			style.className = 'selected';
		}
		style.href = 'javascript:void(0);';
		newElement.appendChild(style);
	}

 Array.from(document.getElementsByTagName('footer')).slice(-1)[0].insertBefore(newElement,
	 null);
}

function get_cookie(cookie_name) {
	var results = document.cookie.match ( '(^|;) ?' + cookie_name + '=([^;]*)(;|$)');
	if (results)
		return (unescape(results[2]));
	else
		return null;
}

function highlightReply(id, evt) {
	if (typeof window.event != "undefined" && event.which == 2) {
		// don't highlight on middle click
		return true;
	}

	var divs = document.getElementsByTagName('div');
	for (var i = 0; i < divs.length; i++)
	{
		if (divs[i].className.indexOf('post') != -1)
			divs[i].className = divs[i].className.replace(/highlighted/, '');
	}
	if (id) {
		var post = document.getElementById('reply_'+id);
		if (post)
			post.className += ' highlighted';
			window.location.hash = id;
	}
  if (evt == undefined)
       return true;
  else{
      left = evt.target.href.split("/");
      left.pop();
      right = window.location.href.split("/");
      right.pop();
      return true //JSON.stringify(left) != JSON.stringify(right); // evt.target.href.split("/").pop().split(".").pop() == window.location.href.split("/").pop().split(".").pop();
  }
	return false;
}

function generatePassword() {
	var pass = '';
	var chars = '{% endraw %}{{ config.genpassword_chars }}{% raw %}';
	for (var i = 0; i < 8; i++) {
		var rnd = Math.floor(Math.random() * chars.length);
		pass += chars.substring(rnd, rnd + 1);
	}
	return pass;
}

function pollSubmit(button){
	var head_element = button.parentNode;
	var inputs = head_element.getElementsByTagName("input");
	var input_arr = [];
	for(var input_index = 0; input_index < inputs.length - 1; input_index++){
		if(inputs[input_index].checked == true)
			input_arr.push(inputs[input_index].value);
	}
	json_answer = JSON.stringify(input_arr);

	var xhttp = new XMLHttpRequest();
	xhttp.onreadystatechange = function(){
		if(this.readyState == 4){
			if(this.status != 200)
				alert("Poll Transfer Error");
			else{ //use response data to build chart
				displayPoll(this.responseText, button);
			}
		}
	}
	xhttp.open("POST", "/poll.php");
	xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	var thread = head_element;
	while(thread && thread != document && thread.id != undefined && thread.id.indexOf("op_") < 0){
		thread = thread.parentNode;
	}
	var board = thread.parentNode.getAttribute("data-board");
	var thread_id = thread.id.replace("op_", "");
	xhttp.send("respond_poll=1&response_json=" + json_answer + "&id=" + thread_id + "&board=" + board);
	return false;
}

function displayPoll(response_text, reference_element){
	   //use response data to build chart
	json_arr = JSON.parse(response_text);
	if(json_arr['error'] != undefined){
						alert(json_arr['error']);
						return;
				}

	var poll_labels = [];
	var poll_data = [];
	var random_bg = [];
	var simple_string = "";
	for(label in json_arr['question']){
		var key = Object.keys(json_arr['question'][label])[0];
		var value = json_arr['question'][label][key];
		if(key == "expires"){
			if(value == json_arr['question'][label]["created"]){
				expiration_time = "Never";
			}
			else{
				var expiration_time = Math.round((parseInt(value) - Date.now()/1000) / 60 / 60);
				expiration_time = expiration_time < 0 ? "Poll Finished" : expiration_time;
			}
			if(typeof expiration_time == "string"){}
			else if(expiration_time / 24 < 1){
				expiration_time = expiration_time  + " Hours";
			}
			else {
			 expiration_time = Math.round(expiration_time / 24)
				if(expiration_time == 1)
					expiration_time += " Day"
				else
					expiration_time += " Days"
			}
			simple_string = simple_string + "<span>Expires in: " +  expiration_time +" </span>";
		}else{
			simple_string += "<span>" + key + " : " + value + "</span><br/>";
			poll_labels.push(key);
			poll_data.push(parseInt(value));
			random_bg.push(json_arr['colors'][label]);
		}
			}


		var inputs = reference_element.parentNode.getElementsByTagName("input");
		for(var i = 0 ; i < inputs.length; i++){
			inputs[i].style = "display:none";
		}
                var labels = reference_element.parentNode.getElementsByTagName("label");
                for(var i = 0 ; i < labels.length; i++){
                        labels[i].style = "display:none";
                }

                var br = reference_element.parentNode.getElementsByTagName("br");
                for(var i = 0 ; i < br.length; i++){
                        br[i].style = "display:none";
                }

		reference_element.parentNode.getElementsByTagName("a")[0].style = "display:none";
		reference_element.parentNode.style = "display:flex;flex-direction:row;justify-content: safe;";
		chart_text_div = document.createElement("div");
		chart_text_div.innerHTML = simple_string;
		chart_text_div.setAttribute("class","poll_data_text");

		chart_canvas_div = document.createElement("div");
		chart_canvas_div.setAttribute('class', 'poll_container');
		bar_chart_canvas = document.createElement("canvas");
		pie_chart_canvas = document.createElement("canvas");

		chart_canvas_div.appendChild(bar_chart_canvas);
		chart_canvas_div.appendChild(pie_chart_canvas);
		reference_element.parentNode.appendChild(chart_canvas_div);
		reference_element.parentNode.appendChild(chart_text_div);

	var bar_cart = new Chart(bar_chart_canvas,
	{
		type: 'horizontalBar',
		data:
		{
			labels: poll_labels,
			datasets:
			[{
				label:"Poll Votes",
				data: poll_data,
				backgroundColor: random_bg
			}]
		},
		options:
		{
			scales: {
				xAxes: [{
							ticks: {
									beginAtZero: true,
						stepSize: 1
							}
						}]

				}
		}
	});

	var pie_cart = new Chart(pie_chart_canvas,
	{
			type: 'pie',
			data:
			{
					labels: poll_labels,
					datasets:
					[{
							label: poll_labels,
							data: poll_data,
							backgroundColor: random_bg
					}]
			},
			options:
			{

			}
	});

}

function viewPoll(op_element){
	var thread = op_element;
	while(thread && thread != document && thread.id != undefined && thread.id.indexOf("op_") < 0){
		thread = thread.parentNode;
	}
	var board = thread.parentNode.getAttribute('data-board');
	var thread_id = thread.id.replace("op_", "");
	var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function(){
		if(this.readyState == 4){
			if(this.status != 200) { //replace with error message where canvas would be
                        	alert("Poll Retrieval Error");
			}
			else{
				displayPoll(this.responseText, op_element);
			}
		}
  }
  xhttp.open("POST", "/poll.php");
  xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
  xhttp.send("query_poll=1&id=" + thread_id + "&board=" + board);
  return false;
}

function dopost(form) {
	if (form.elements['name']) {
		//localStorage.name = form.elements['name'].value;
	}
	if (form.elements['wl_token[]']) {
		localStorage.setItem("whitelist", form.elements['wl_token[]'].value);
	}

	if (form.elements['email'] /*&& form.elements['email'].value != 'sage'*/) {
		localStorage.email = form.elements['email'].value.replace(/\bsage\b/, "");
	}

	saved[document.location] = form.elements['body'].value;
	sessionStorage.body = JSON.stringify(saved);

	return form.elements['body'].value != "" || (form.elements['file'] && form.elements['file'].value != "") || (form.elements.file_url && form.elements['file_url'].value != "");
}
function setWhitelistToken(){
	var id = prompt("Input Token ID", localStorage.getItem("whitelist") ?  localStorage.getItem("whitelist") : "");
	if (id != undefined) {
		document.forms.post.elements['wl_token[]'].value = id;
		localStorage.setItem("whitelist", id);
	}
}

function citeReply(id, with_link) {
	var textarea;
	if(document.getElementById('index-body') != undefined)
		textarea = document.getElementById('index-body');
	else
        	textarea = document.getElementById('body');
	if (!textarea){
		 return false;
	}
	if (document.selection) {
		// IE
		textarea.focus();
		var sel = document.selection.createRange();
		sel.text = '>>' + id + '\n';
	} else if (textarea.selectionStart || textarea.selectionStart == '0') {
		var start = textarea.selectionStart;
		var end = textarea.selectionEnd;
		textarea.value = textarea.value.substring(0, start) + '>>' + id + '\n' + textarea.value.substring(end, textarea.value.length);

		textarea.selectionStart += ('>>' + id).length + 1;
		textarea.selectionEnd = textarea.selectionStart;
	} else {
		// ???
		textarea.value += '>>' + id + '\n';
	}
	if (typeof $ != 'undefined') {
		var select = document.getSelection().toString();
		if (select) {
			var body = $('#reply_' + id + ', #op_' + id).find('div.body');  // TODO: support for OPs
			var index = body.text().indexOf(select.replace('\n', ''));  // for some reason this only works like this
			if (index > -1) {
				textarea.value += '>' + select + '\n';
			}
		}

		$(window).trigger('cite', [id, with_link]);
		$(textarea).change();
	}
	return false;
}

function captchaSetup(){
	$(".cap").click(function(e, handl){
		if(localStorage.getItem("captcha") == "cap"){
			return;
		}
		localStorage.setItem("captcha",  "cap");
		$(".cap").each(function(index, el){
			if(el != e.currentTarget){
				el.click();
			}
		});
	});
	$(".rec").click(function(e, handl){
		if(localStorage.getItem("captcha") == "rec"){
			return;
		}
		localStorage.setItem("captcha", "rec");
		$(".rec").each(function(index, el){
			if(el != e.currentTarget){
				el.click();
			}
		});
	});

	var captcha_val = localStorage.getItem("captcha");
	if(captcha_val == null || captcha_val == "cap"){
		var cap = $(".cap");
		for(var i = 0 ; i < cap.length ; i++){
			cap[i].setAttribute("checked", true)
		}
	}
	else{
		var rec = $(".rec");
		for(var i = 0 ; i < rec.length ; i++){
			rec[i].setAttribute("checked", true)
		}
	}
}

function rememberStuff() {
	if (document.forms.post) {
		if (document.forms.post.pswrd) {
			if (!localStorage.getItem("pswrd") || localStorage.getItem("pswrd") == "undefined")
				localStorage.setItem("pswrd", generatePassword());
			document.forms.post.pswrd.value = localStorage.getItem("pswrd");
		}
		if (document.forms.post["wl_token[]"] && localStorage.getItem("whitelist")) {
			document.forms.post["wl_token[]"].value = localStorage.getItem("whitelist");
		}
		// inconvinient with hidden post form
		// if (localStorage.name && document.forms.post.elements['name'])
		// 	document.forms.post.elements['name'].value = localStorage.name;
		if (localStorage.email && document.forms.post.elements['email'])
			document.forms.post.elements['email'].value = localStorage.email;

		if (window.location.hash.indexOf('q') == 1 && window.location.hash.indexOf('a') != 2)
			citeReply(window.location.hash.substring(2), true);

		if (sessionStorage.body) {
			var saved = JSON.parse(sessionStorage.body);
			if (get_cookie('{% endraw %}{{ config.cookies.js }}{% raw %}')) {
				// Remove successful posts
				var successful = JSON.parse(get_cookie('{% endraw %}{{ config.cookies.js }}{% raw %}'));
				for (var url in successful) {
					saved[url] = null;
				}
				sessionStorage.body = JSON.stringify(saved);

				document.cookie = '{% endraw %}{{ config.cookies.js }}{% raw %}={};expires=0;path=/;';
			}
			if (saved[document.location]) {
				document.forms.post.body.value = saved[document.location];
			}
		}

		if (localStorage.body) {
			document.forms.post.body.value = localStorage.body;
			localStorage.body = '';
		}
	}
}

var script_settings = function(script_name) {
	this.script_name = script_name;
	this.get = function(var_name, default_val) {
		if (typeof tb_settings == 'undefined' ||
			typeof tb_settings[this.script_name] == 'undefined' ||
			typeof tb_settings[this.script_name][var_name] == 'undefined')
			return default_val;
		return tb_settings[this.script_name][var_name];
	}
};

function setCaptchouliListeners(e){
	 document.getElementById("captchouli-frame").addEventListener("load", function(e){
		 var pre_tags = document.getElementById("captchouli-frame").contentWindow.document.getElementsByTagName("pre");
		 if(pre_tags.length == 1){
			 document.getElementById("captchouli-code").value = pre_tags[0].textContent
			 document.getElementById("captchouli-submit").click();
		 }
	 });
}

function init() {
	init_stylechooser();

	$("#option_simplifier").change(function(e){
		$("#option_input").val($("#option_input").val() + " " + $( "#option_simplifier option:selected" ).val());
	});

	{% endraw %}
	{% if config.allow_delete %}
	if(document.forms.postcontrols != undefined){
		if (document.forms.postcontrols.pswrd) {
			if (!localStorage.getItem("pswrd") || localStorage.getItem("pswrd") == "undefined"){
				var pswrd = generatePassword();
				localStorage.setItem("pswrd" , pswrd);
				document.forms.postcontrols.pswrd.value = pswrd;
			}
		}
		if (document.forms.post["wl_token[]"] && localStorage.getItem("whitelist")) {
			document.forms.post["wl_token[]"].value = localStorage.getItem("whitelist");
		}
	}
	{% endif %}
	{% raw %}
	if(window.location.hash.indexOf('-') == -1){
		highlightReply(window.location.hash.substring(window.location.hash.indexOf('q') + 1));
	}
	else if (window.location.hash.substring(window.location.hash.indexOf('-'))){
		highlightReply(window.location.hash.substring(window.location.hash.indexOf('-') + 1));
	}

	captchaSetup();
}

var RecaptchaOptions = {
	theme : 'clean'
};

onready_callbacks = [];
function onready(fnc) {
	onready_callbacks.push(fnc);
}

function ready() {
	for (var i = 0; i < onready_callbacks.length; i++) {
			onready_callbacks[i]();
	}
}

{% endraw %}

var post_date = "{{ config.post_date }}";
var max_images = {{ config.max_images }};

onready(init);

{% if config.google_analytics %}{% raw %}

var _gaq = _gaq || [];_gaq.push(['_setAccount', '{% endraw %}{{ config.google_analytics }}{% raw %}']);{% endraw %}{% if config.google_analytics_domain %}{% raw %}_gaq.push(['_setDomainName', '{% endraw %}{{ config.google_analytics_domain }}{% raw %}']){% endraw %}{% endif %}{% if not config.google_analytics_domain %}{% raw %}_gaq.push(['_setDomainName', 'none']){% endraw %}{% endif %}{% raw %};_gaq.push(['_trackPageview']);(function() {var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;ga.src = ('https:' == document.location.protocol ? 'https://' : 'http://') + 'stats.g.doubleclick.net/dc.js';var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);})();{% endraw %}{% endif %}

{% if config.statcounter_project and config.statcounter_security %}
var sc = document.createElement('script');
sc.type = 'text/javascript';
sc.innerHTML = 'var sc_project={{ config.statcounter_project }};var sc_invisible=1;var sc_security="{{ config.statcounter_security }}";var scJsHost=(("https:" == document.location.protocol) ? "https://secure." : "http://www.");document.write("<sc"+"ript type=text/javascript src="+scJsHost+"statcounter.com/counter/counter.js></"+"script>");';
var s = document.getElementsByTagName('script')[0];
s.parentNode.insertBefore(sc, s);
{% endif %}
